setwd("C:\\Users\\jaime4\\Desktop\\Canada\\Courses\\690\\2017\\Questions\\Inkscape lab")

#############################################
#### Constrained Correspondence Analysis ####
#############################################

library(vegan)

means=read.csv("AB_Climate_Trees.csv")
rownames(means)=means$ECOSYS # creates rownames
trees=means[c(1:5,8:10,13:17),11:23]
climate=means[c(1:5,8:10,13:17),3:10] 

output=cca(trees~MAT+MWMT+MCMT+lnMAP+lnMSP, data=climate)
output
plot(output, choices=c(1,2), scaling=3)

######################################
#### Multivariate Regression Tree ####
######################################

library(mvpart)
dat2=read.csv("AB_Tree_Plots_Normalized.csv")
spec2=as.matrix(dat2[,8:10])
out2=mvpart(spec2~MAT+MWMT+MCMT+MAP+MSP, dat2, all.leaves=T)

####################
#### Save plots ####
####################

pdf(file = "CCA.pdf", useDingbats = FALSE, width=15/2.54, height=15/2.54)
plot(output, choices=c(1,2), scaling=3)
dev.off()

png(file = "CCA.png", width=15, height=15,units="cm",res=100)
plot(output, choices=c(1,2), scaling=3)
dev.off()

pdf(file = "MRT.pdf", useDingbats = FALSE, width=14/2.54, height=16/2.54)
mvpart(spec2~MAT+MWMT+MCMT+MAP+MSP, dat2, all.leaves=T)
dev.off()
